/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.data.tcon;

import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.item.BYGItems;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IByproduct;
import slimeknights.tconstruct.library.data.recipe.ICommonRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.IRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.ISmelteryRecipeHelper;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.smeltery.data.Byproduct;
import tcintegrations.common.TagManager;
import tcintegrations.data.integration.ModIntegration;
import tcintegrations.data.tcon.SmelteryCompat;
import tcintegrations.items.TCIntegrationsItems;

public class SmelteryRecipeProvider
extends RecipeProvider
implements IConditionBuilder,
IRecipeHelper,
ISmelteryRecipeHelper,
ICommonRecipeHelper {
    public SmelteryRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    public String m_6055_() {
        return "TCIntegrations - TCon Smeltery Recipes";
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        this.addMeltingRecipes(consumer);
        this.addCastingRecipes(consumer);
        this.addAlloyRecipes(consumer);
    }

    public String getModId() {
        return "tcintegrations";
    }

    private void addCastingRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "smeltery/casting/";
        String metalFolder = folder + "metal/";
        HashMap<String, Consumer> modConsumers = new HashMap<String, Consumer>();
        Consumer arsConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("ars_nouveau")});
        Consumer bygConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("byg")});
        modConsumers.put("botania", this.withCondition(consumer, new ICondition[]{this.modLoaded("botania")}));
        modConsumers.put("aquaculture", this.withCondition(consumer, new ICondition[]{this.modLoaded("aquaculture")}));
        modConsumers.put("malum", this.withCondition(consumer, new ICondition[]{this.modLoaded("malum")}));
        modConsumers.put("undergarden", this.withCondition(consumer, new ICondition[]{this.modLoaded("undergarden")}));
        modConsumers.put("byg", bygConsumer);
        this.gemCasting(arsConsumer, TCIntegrationsItems.MOLTEN_SOURCE_GEM, (ItemLike)ItemsRegistry.SOURCE_GEM.m_5456_(), folder + "source_gem/gem");
        ItemCastingRecipeBuilder.basinRecipe((ItemLike)BlockRegistry.SOURCE_GEM_BLOCK).setFluidAndTime(TCIntegrationsItems.MOLTEN_SOURCE_GEM, false, 400).save(arsConsumer, this.prefix((Supplier)TCIntegrationsItems.MOLTEN_SOURCE_GEM, folder + "source_gem/block"));
        this.ingotCasting(bygConsumer, TCIntegrationsItems.MOLTEN_PENDORITE, false, (ItemLike)BYGItems.PENDORITE_SCRAPS.get(), metalFolder + "pendorite/scrap");
        this.metalCasting(bygConsumer, TCIntegrationsItems.MOLTEN_PENDORITE_ALLOY, false, (ItemLike)BYGBlocks.PENDORITE_BLOCK.get(), (ItemLike)BYGItems.PENDORITE_INGOT.get(), null, metalFolder, "pendorite_alloy/block");
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            this.metalTagCasting((Consumer)modConsumers.get(compat.getModid()), compat.getFluid(), compat.getName(), metalFolder, false);
        }
    }

    private void addMeltingRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "smeltery/melting/";
        String metalFolder = folder + "metal/";
        Consumer botaniaConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("botania")});
        Consumer aquacultureConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("aquaculture")});
        Consumer malumConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("malum")});
        Consumer undergardenConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("undergarden")});
        Consumer beyondEarthConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("beyond_earth")});
        Consumer bygConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("byg")});
        this.metalMelting(botaniaConsumer, (Fluid)TCIntegrationsItems.MOLTEN_MANASTEEL.get(), "manasteel", false, metalFolder, false, new IByproduct[]{Byproduct.IRON});
        this.metalMelting(aquacultureConsumer, (Fluid)TCIntegrationsItems.MOLTEN_NEPTUNIUM.get(), "neptunium", false, metalFolder, false, new IByproduct[0]);
        this.metalMelting(malumConsumer, (Fluid)TCIntegrationsItems.MOLTEN_SOUL_STAINED_STEEL.get(), "soul_stained_steel", false, metalFolder, false, new IByproduct[]{Byproduct.IRON});
        this.metalMelting(undergardenConsumer, (Fluid)TCIntegrationsItems.MOLTEN_CLOGGRUM.get(), "cloggrum", true, metalFolder, false, new IByproduct[0]);
        this.metalMelting(undergardenConsumer, (Fluid)TCIntegrationsItems.MOLTEN_FROSTSTEEL.get(), "froststeel", true, metalFolder, false, new IByproduct[0]);
        this.metalMelting(undergardenConsumer, (Fluid)TCIntegrationsItems.MOLTEN_FORGOTTEN.get(), "forgotten", false, metalFolder, false, new IByproduct[0]);
        this.metalMelting(beyondEarthConsumer, (Fluid)ModIntegration.MOLTEN_DESH.get(), "desh", true, metalFolder, false, new IByproduct[0]);
        this.metalMelting(beyondEarthConsumer, (Fluid)ModIntegration.MOLTEN_CALORITE.get(), "calorite", true, metalFolder, false, new IByproduct[0]);
        this.metalMelting(beyondEarthConsumer, (Fluid)ModIntegration.MOLTEN_OSTRUM.get(), "ostrum", true, metalFolder, false, new IByproduct[0]);
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_(TagManager.Items.EMERALDITE_SHARDS), (Fluid)TinkerFluids.moltenEmerald.get(), (int)25, (float)1.0f).setOre(IMeltingContainer.OreRateType.GEM, new IMeltingContainer.OreRateType[0]).save(bygConsumer, this.modResource("emeraldite/shard"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_(TagManager.Items.EMERALDITE_ORE), (Fluid)TinkerFluids.moltenEmerald.get(), (int)25, (float)1.0f).setOre(IMeltingContainer.OreRateType.GEM, new IMeltingContainer.OreRateType[0]).save(bygConsumer, this.modResource("emeraldite/ore"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BYGItems.PENDORITE_ORE.get()}), (Fluid)TCIntegrationsItems.MOLTEN_PENDORITE.get(), (int)90, (float)2.0f).setOre(IMeltingContainer.OreRateType.METAL, new IMeltingContainer.OreRateType[]{IMeltingContainer.OreRateType.GEM, IMeltingContainer.OreRateType.METAL}).save(bygConsumer, this.modResource(metalFolder + "pendorite/ore"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BYGItems.RAW_PENDORITE.get()}), (Fluid)TCIntegrationsItems.MOLTEN_PENDORITE.get(), (int)90, (float)2.0f).setOre(IMeltingContainer.OreRateType.METAL, new IMeltingContainer.OreRateType[]{IMeltingContainer.OreRateType.GEM, IMeltingContainer.OreRateType.METAL}).save(bygConsumer, this.modResource(metalFolder + "pendorite/raw"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BYGItems.RAW_PENDORITE_BLOCK.get()}), (Fluid)TCIntegrationsItems.MOLTEN_PENDORITE.get(), (int)810, (float)2.0f).setOre(IMeltingContainer.OreRateType.METAL, new IMeltingContainer.OreRateType[]{IMeltingContainer.OreRateType.GEM, IMeltingContainer.OreRateType.METAL}).save(bygConsumer, this.modResource(metalFolder + "pendorite/raw_block"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BYGItems.PENDORITE_SCRAPS.get()}), (Fluid)TCIntegrationsItems.MOLTEN_PENDORITE.get(), (int)90, (float)2.0f).setOre(IMeltingContainer.OreRateType.METAL, new IMeltingContainer.OreRateType[]{IMeltingContainer.OreRateType.GEM, IMeltingContainer.OreRateType.METAL}).save(bygConsumer, this.modResource(metalFolder + "pendorite/scrap"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BYGItems.PENDORITE_INGOT.get()}), (Fluid)TCIntegrationsItems.MOLTEN_PENDORITE_ALLOY.get(), (int)90, (float)2.0f).setOre(IMeltingContainer.OreRateType.METAL, new IMeltingContainer.OreRateType[]{IMeltingContainer.OreRateType.GEM, IMeltingContainer.OreRateType.METAL}).save(bygConsumer, this.modResource(metalFolder + "pendorite_alloy/ingot"));
    }

    private void addAlloyRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "smeltery/alloys/";
        Consumer bygConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("byg")});
        ConditionalRecipe.builder().addCondition((ICondition)new TagEmptyCondition(new ResourceLocation("forge", "ingots/tin"))).addRecipe(arg_0 -> ((AlloyRecipeBuilder)AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenBronze.get(), (int)360).addInput(TinkerFluids.moltenCopper.getForgeTag(), 270).addInput(TinkerFluids.moltenQuartz.getLocalTag(), 100)).save(arg_0)).build(consumer, this.prefix((Supplier)TinkerFluids.moltenBronze, folder));
        AlloyRecipeBuilder.alloy((Fluid)TCIntegrationsItems.MOLTEN_PENDORITE_ALLOY.get(), (int)90).addInput(TCIntegrationsItems.MOLTEN_PENDORITE.getForgeTag(), 360).addInput(TinkerFluids.moltenDiamond.getLocalTag(), 200).addInput(TinkerFluids.moltenEmerald.getLocalTag(), 50).save(bygConsumer, this.prefix((Supplier)TCIntegrationsItems.MOLTEN_PENDORITE_ALLOY, folder));
    }
}

